/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.GuiNpcMobSpawnerSelector;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.data.SpawnNPCData;

public class GuiNpcSpawner
extends GuiNPCInterface2
implements IGuiData,
ICustomScrollListener,
ITextfieldListener,
ISubGuiListener {
    private final JobSpawner job;
    private int slot = -1;
    private GuiCustomScroll deadScroll;
    private GuiCustomScroll aliveScroll;
    public EntityLivingBase selectNpc;
    private boolean isDead = false;

    public GuiNpcSpawner(EntityNPCInterface npc) {
        super(npc);
        this.job = (JobSpawner)npc.advanced.jobInterface;
        Client.sendData(EnumPacketServer.JobGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 1: {
                this.isDead = false;
                this.slot = -1;
                this.setSubGui(this.getSelector());
                break;
            }
            case 2: {
                if (this.isDead) {
                    return;
                }
                Client.sendData(EnumPacketServer.JobSpawnerRemove, this.slot, false);
                this.func_73866_w_();
                break;
            }
            case 3: {
                if (this.isDead) {
                    return;
                }
                this.setSubGui(this.getSelector());
                break;
            }
            case 4: {
                if (this.isDead || this.slot < 1) {
                    return;
                }
                Client.sendData(EnumPacketServer.SpawnerNpcMove, this.slot, true, false);
                --this.slot;
                this.func_73866_w_();
                break;
            }
            case 5: {
                if (this.isDead || this.slot >= this.job.size(false)) {
                    return;
                }
                Client.sendData(EnumPacketServer.SpawnerNpcMove, this.slot, false, this.isDead);
                ++this.slot;
                this.func_73866_w_();
                break;
            }
            case 6: {
                Client.sendData(EnumPacketServer.JobClear, false);
                break;
            }
            case 7: {
                this.job.setDespawnOnTargetLost(false, ((GuiNpcCheckBox)button).isSelected());
                break;
            }
            case 8: {
                this.job.setSpawnType(false, button.getValue());
                break;
            }
            case 9: {
                this.isDead = true;
                this.slot = -1;
                this.setSubGui(this.getSelector());
                break;
            }
            case 10: {
                if (!this.isDead) {
                    return;
                }
                Client.sendData(EnumPacketServer.JobSpawnerRemove, this.slot, true);
                this.func_73866_w_();
                break;
            }
            case 11: {
                if (!this.isDead) {
                    return;
                }
                this.setSubGui(this.getSelector());
                break;
            }
            case 12: {
                if (!this.isDead || this.slot < 1) {
                    return;
                }
                Client.sendData(EnumPacketServer.SpawnerNpcMove, this.slot, true, true);
                --this.slot;
                this.func_73866_w_();
                break;
            }
            case 13: {
                if (!this.isDead || this.slot >= this.job.size(true)) {
                    return;
                }
                Client.sendData(EnumPacketServer.SpawnerNpcMove, this.slot, false, this.isDead);
                ++this.slot;
                this.func_73866_w_();
                break;
            }
            case 14: {
                Client.sendData(EnumPacketServer.JobClear, true);
                break;
            }
            case 15: {
                this.job.setDespawnOnTargetLost(true, ((GuiNpcCheckBox)button).isSelected());
                break;
            }
            case 16: {
                this.job.setSpawnType(true, button.getValue());
                break;
            }
            case 17: {
                this.job.exact = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 18: {
                this.job.resetUpdate = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface gui) {
        GuiNpcMobSpawnerSelector selector = (GuiNpcMobSpawnerSelector)gui;
        if (this.slot < 0) {
            this.slot = (this.isDead ? this.deadScroll : this.aliveScroll).getList().size();
        }
        if (selector.showingClones == 2) {
            String selected = selector.getSelected();
            if (selected != null) {
                Client.sendData(EnumPacketServer.JobSpawnerAdd, true, this.isDead, this.slot, selected, selector.activeTab);
                Client.sendData(EnumPacketServer.GetClone, true, this.slot, this.isDead);
            }
        } else {
            NBTTagCompound nbtNpc = selector.getCompound();
            if (nbtNpc == null) {
                return;
            }
            SpawnNPCData sd = selector.spawnData;
            if (this.slot < 0) {
                this.slot = this.job.size(this.isDead);
            }
            sd.compound = nbtNpc;
            if (sd.typeClones == 0) {
                sd.compound.func_74768_a("ClonedTab", selector.activeTab);
            }
            this.job.readJobCompound(this.slot, this.isDead, sd.writeToNBT());
            Client.sendData(EnumPacketServer.JobSpawnerAdd, false, this.isDead, this.slot, sd.writeToNBT());
            Client.sendData(EnumPacketServer.GetClone, true, this.slot, this.isDead);
        }
        this.func_73866_w_();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.subgui == null) {
            GlStateManager.func_179094_E();
            if (this.selectNpc != null) {
                this.drawNpc((Entity)this.selectNpc, 385, 92, 1.0f, (int)(3L * this.player.field_70170_p.func_82737_E() % 360L), 0, 0);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            this.func_73728_b(this.guiLeft + 178, this.guiTop + 4, this.guiTop + this.ySize + 12, -12566464);
            this.func_73728_b(this.guiLeft + 353, this.guiTop + 4, this.guiTop + this.ySize + 12, -12566464);
            Gui.func_73734_a((int)(this.guiLeft + 355), (int)(this.guiTop + 13), (int)(this.guiLeft + 416), (int)(this.guiTop + 99), (int)-8355712);
            Gui.func_73734_a((int)(this.guiLeft + 356), (int)(this.guiTop + 14), (int)(this.guiLeft + 415), (int)(this.guiTop + 98), (int)-16777216);
            GlStateManager.func_179121_F();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void elementClicked() {
    }

    private GuiNpcMobSpawnerSelector getSelector() {
        GuiNpcMobSpawnerSelector guiMSS = new GuiNpcMobSpawnerSelector();
        SpawnNPCData sd = this.job.get(this.slot, this.isDead);
        if (sd == null) {
            sd = new SpawnNPCData();
        }
        guiMSS.spawnData = sd;
        guiMSS.showingClones = sd.typeClones;
        if ((sd.typeClones == 0 || sd.typeClones == 2) && sd.compound != null && sd.compound.func_150297_b("ClonedTab", 3)) {
            guiMSS.activeTab = sd.compound.func_74762_e("ClonedTab");
        }
        return guiMSS;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.aliveScroll == null) {
            this.aliveScroll = new GuiCustomScroll(this, 1);
            this.aliveScroll.setSize(172, 101);
        }
        this.aliveScroll.guiLeft = this.guiLeft + 5;
        this.aliveScroll.guiTop = this.guiTop + 14;
        if (!this.isDead) {
            if (this.slot >= 0 && this.slot < this.aliveScroll.getList().size()) {
                this.aliveScroll.setSelect(this.slot);
            } else {
                this.slot = -1;
                this.aliveScroll.setSelect(-1);
                this.selectNpc = null;
            }
        } else {
            this.aliveScroll.setSelect(-1);
        }
        this.addScroll(this.aliveScroll);
        if (this.deadScroll == null) {
            this.deadScroll = new GuiCustomScroll(this, 0);
            this.deadScroll.setSize(172, 101);
        }
        this.deadScroll.guiLeft = this.guiLeft + 180;
        this.deadScroll.guiTop = this.guiTop + 14;
        if (this.isDead) {
            if (this.slot >= 0 && this.slot < this.deadScroll.getList().size()) {
                this.deadScroll.setSelect(this.slot);
            } else {
                this.slot = -1;
                this.deadScroll.setSelect(-1);
                this.selectNpc = null;
            }
        } else {
            this.deadScroll.setSelect(-1);
        }
        this.addScroll(this.deadScroll);
        GuiNpcLabel label = new GuiNpcLabel(1, "spawner.list.0", this.guiLeft + 6, this.guiTop + 4);
        label.setHoverText(new TextComponentTranslation("spawner.hover.list.0", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("spawner.hover.list.2", new Object[0])).func_150254_d(), new Object[0]);
        this.addLabel(label);
        label = new GuiNpcLabel(2, "spawner.list.1", this.guiLeft + 182, this.guiTop + 4);
        label.setHoverText(new TextComponentTranslation("spawner.hover.list.1", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("spawner.hover.list.2", new Object[0])).func_150254_d(), new Object[0]);
        this.addLabel(label);
        TextComponentTranslation strAlive = new TextComponentTranslation("spawner.hover.sp.0", new Object[0]);
        GuiNpcButton button = new GuiNpcButton(1, this.guiLeft + 5, this.guiTop + 116, 56, 20, "gui.add");
        button.setHoverText(new TextComponentTranslation("spawner.hover.add", new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 63, this.guiTop + 116, 56, 20, "gui.remove");
        button.setEnabled(!this.isDead && this.slot >= 0);
        button.setHoverText(new TextComponentTranslation("spawner.hover.del", new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.guiLeft + 121, this.guiTop + 116, 56, 20, "advanced.editingmode");
        button.setEnabled(!this.isDead && this.slot >= 0);
        button.setHoverText(new TextComponentTranslation("spawner.hover.change", new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, this.guiLeft + 5, this.guiTop + 138, 56, 20, "type.up");
        button.setEnabled(!this.isDead && this.slot >= 0 && this.slot >= 1);
        button.setHoverText(new TextComponentTranslation("spawner.hover.up", new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(5, this.guiLeft + 63, this.guiTop + 138, 56, 20, "type.down");
        button.setEnabled(!this.isDead && this.slot >= 0 && this.slot < this.aliveScroll.getList().size() - 1);
        button.setHoverText(new TextComponentTranslation("spawner.hover.down", new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(6, this.guiLeft + 121, this.guiTop + 138, 56, 20, "gui.clear");
        button.setEnabled(!this.aliveScroll.getList().isEmpty());
        button.setHoverText(new TextComponentTranslation("spawner.hover.clear", new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(4, "type.offset", this.guiLeft + 6, this.guiTop + 166));
        this.addLabel(new GuiNpcLabel(5, "X:", this.guiLeft + 44, this.guiTop + 166));
        int[] set = this.job.getOffset(false);
        if (set == null) {
            set = new int[]{0, 0, 0};
        }
        if (set.length != 3) {
            int[] ns = new int[]{0, 0, 0};
            System.arraycopy(set, 0, ns, 0, set.length);
            set = ns;
        }
        GuiNpcTextField textField = new GuiNpcTextField(0, this, this.guiLeft + 52, this.guiTop + 161, 35, 15, "" + set[0]);
        textField.setMinMaxDefault(0L, 5L, set[0]);
        textField.setHoverText(new TextComponentTranslation("spawner.hover.axis.offset", new Object[]{"X"}).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(6, "Y:", this.guiLeft + 89, this.guiTop + 166));
        textField = new GuiNpcTextField(1, this, this.guiLeft + 97, this.guiTop + 161, 35, 15, "" + set[1]);
        textField.setMinMaxDefault(0L, 5L, set[1]);
        textField.setHoverText(new TextComponentTranslation("spawner.hover.axis.offset", new Object[]{"Y"}).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(7, "Z:", this.guiLeft + 134, this.guiTop + 166));
        textField = new GuiNpcTextField(2, this, this.guiLeft + 142, this.guiTop + 161, 35, 15, "" + set[2]);
        textField.setMinMaxDefault(0L, 5L, set[2]);
        textField.setHoverText(new TextComponentTranslation("spawner.hover.axis.offset", new Object[]{"Z"}).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcCheckBox(7, this.guiLeft + 5, this.guiTop + 176, 170, 14, "spawner.despawn", null, this.job.getDespawnOnTargetLost(false));
        button.setHoverText(new TextComponentTranslation("spawner.hover.des.tr.lost", new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(8, "spawner.type", this.guiLeft + 5, this.guiTop + 195));
        button = new GuiNpcButton(8, this.guiLeft + 63, this.guiTop + 190, 55, 20, new String[]{"spawner.one", "spawner.all", "spawner.random"}, this.job.getSpawnType(false));
        button.setHoverText(new TextComponentTranslation("spawner.hover.type.0." + this.job.getSpawnType(false), new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        TextComponentTranslation strDead = new TextComponentTranslation("spawner.hover.sp.1", new Object[0]);
        button = new GuiNpcButton(9, this.guiLeft + 180, this.guiTop + 116, 56, 20, "gui.add");
        button.setHoverText(new TextComponentTranslation("spawner.hover.add", new Object[0]).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(10, this.guiLeft + 238, this.guiTop + 116, 56, 20, "gui.remove");
        button.setEnabled(this.slot >= 0);
        button.setHoverText(new TextComponentTranslation("spawner.hover.del", new Object[0]).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(11, this.guiLeft + 296, this.guiTop + 116, 56, 20, "advanced.editingmode");
        button.setEnabled(this.isDead && this.slot >= 0);
        button.setHoverText(new TextComponentTranslation("spawner.hover.change", new Object[0]).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(12, this.guiLeft + 180, this.guiTop + 138, 56, 20, "type.up");
        button.setEnabled(this.isDead && this.slot >= 0 && this.slot >= 1);
        button.setHoverText(new TextComponentTranslation("spawner.hover.up", new Object[0]).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(13, this.guiLeft + 238, this.guiTop + 138, 56, 20, "type.down");
        button.setEnabled(this.isDead && this.slot >= 0 && this.slot < this.deadScroll.getList().size() - 1);
        button.setHoverText(new TextComponentTranslation("spawner.hover.down", new Object[0]).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(14, this.guiLeft + 296, this.guiTop + 138, 56, 20, "gui.clear");
        button.setEnabled(!this.deadScroll.getList().isEmpty());
        button.setHoverText(new TextComponentTranslation("spawner.hover.clear", new Object[0]).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(9, "type.offset", this.guiLeft + 181, this.guiTop + 166));
        this.addLabel(new GuiNpcLabel(10, "X:", this.guiLeft + 219, this.guiTop + 166));
        set = this.job.getOffset(true);
        if (set == null) {
            set = new int[]{0, 0, 0};
        }
        if (set.length != 3) {
            int[] ns = new int[]{0, 0, 0};
            System.arraycopy(set, 0, ns, 0, set.length);
            set = ns;
        }
        textField = new GuiNpcTextField(3, this, this.guiLeft + 227, this.guiTop + 161, 35, 15, "" + set[0]);
        textField.setMinMaxDefault(0L, 5L, set[0]);
        textField.setHoverText(new TextComponentTranslation("spawner.hover.axis.offset", new Object[]{"X"}).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(11, "Y:", this.guiLeft + 264, this.guiTop + 166));
        textField = new GuiNpcTextField(4, this, this.guiLeft + 272, this.guiTop + 161, 35, 15, "" + set[1]);
        textField.setMinMaxDefault(0L, 5L, set[1]);
        textField.setHoverText(new TextComponentTranslation("spawner.hover.axis.offset", new Object[]{"Y"}).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(12, "Z:", this.guiLeft + 309, this.guiTop + 166));
        textField = new GuiNpcTextField(5, this, this.guiLeft + 317, this.guiTop + 161, 35, 15, "" + set[2]);
        textField.setMinMaxDefault(0L, 5L, set[2]);
        textField.setHoverText(new TextComponentTranslation("spawner.hover.axis.offset", new Object[]{"Z"}).func_150257_a((ITextComponent)strDead).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcCheckBox(15, this.guiLeft + 180, this.guiTop + 176, 170, 14, "spawner.despawn", null, this.job.getDespawnOnTargetLost(true));
        button.setHoverText(new TextComponentTranslation("spawner.hover.des.tr.lost", new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(13, "spawner.type", this.guiLeft + 180, this.guiTop + 195));
        button = new GuiNpcButton(16, this.guiLeft + 238, this.guiTop + 190, 55, 20, new String[]{"spawner.one", "spawner.all", "spawner.random"}, this.job.getSpawnType(true));
        button.setHoverText(new TextComponentTranslation("spawner.hover.type.1." + this.job.getSpawnType(true), new Object[0]).func_150257_a((ITextComponent)strAlive).func_150254_d(), new Object[0]);
        this.addButton(button);
        TextComponentTranslation strBoth = new TextComponentTranslation("spawner.hover.sp.2", new Object[0]);
        button = new GuiNpcCheckBox(17, this.guiLeft + 357, this.guiTop + 161, 98, 14, "type.exact", null, this.job.exact);
        button.setHoverText(new TextComponentTranslation("spawner.hover.exact", new Object[0]).func_150257_a((ITextComponent)strBoth).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(18, this.guiLeft + 357, this.guiTop + 176, 98, 14, "script.update", null, this.job.resetUpdate);
        button.setHoverText(new TextComponentTranslation("spawner.hover.reset", new Object[0]).func_150257_a((ITextComponent)strBoth).func_150254_d(), new Object[0]);
        this.addButton(button);
        label = new GuiNpcLabel(14, "spawner.cooldown", this.guiLeft + 358, this.guiTop + 132);
        label.enabled = !this.aliveScroll.getList().isEmpty();
        this.addLabel(label);
        textField = new GuiNpcTextField(6, this, this.guiLeft + 357, this.guiTop + 144, 55, 15, "" + this.job.getCooldown() / 50L);
        textField.setMinMaxDefault(0L, 6000L, (int)(this.job.getCooldown() / 50L));
        textField.func_146189_e(!this.aliveScroll.getList().isEmpty());
        textField.setHoverText("spawner.hover.cooldown", new Object[0]);
        this.addTextField(textField);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
        }
        super.func_73869_a(c, i);
        if (i == 200 || i == 208 || i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() || i == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.resetEntity();
        }
    }

    private void resetEntity() {
        String sel = (this.isDead ? this.deadScroll : this.aliveScroll).getSelected();
        if (sel == null) {
            this.selectNpc = null;
            return;
        }
        SpawnNPCData sd = this.job.get(this.slot, this.isDead);
        if (sd == null) {
            this.selectNpc = null;
            return;
        }
        if (sd.typeClones == 2) {
            Client.sendData(EnumPacketServer.GetClone, false, sel, sd.compound.func_74762_e("Tab"));
        } else {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)sd.compound, (World)Minecraft.func_71410_x().field_71441_e);
            if (entity instanceof EntityLivingBase) {
                this.selectNpc = (EntityLivingBase)entity;
            }
        }
    }

    @Override
    public void save() {
        NBTTagCompound compound = this.job.save(new NBTTagCompound());
        this.job.removeCompound(compound);
        Client.sendData(EnumPacketServer.JobSave, compound);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.slot = scroll.getSelect();
        this.isDead = scroll.getID() == 0;
        (this.isDead ? this.aliveScroll : this.deadScroll).setSelect(-1);
        SpawnNPCData sd = this.job.get(this.slot, this.isDead);
        if (sd != null && sd.compound != null) {
            Client.sendData(EnumPacketServer.GetClone, true, this.slot, this.isDead);
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        this.setSubGui(this.getSelector());
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        SpawnNPCData sd;
        if (compound.func_150297_b("NPCData", 10)) {
            this.selectNpc = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)compound.func_74775_l("NPCData"), (World)this.player.field_70170_p);
            return;
        }
        char chr = '\u00a7';
        this.job.load(compound);
        for (int j = 0; j < 2; ++j) {
            boolean type = j == 0;
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this.job.size(type); ++i) {
                SpawnNPCData sd2 = this.job.get(i, type);
                list.add(chr + "7" + (i + 1) + ": " + chr + "r" + sd2.getTitle() + chr + (sd2.typeClones == 0 ? "a (Client)" : (sd2.typeClones == 1 ? "c (Mob)" : "b (Server)")));
            }
            (type ? this.deadScroll : this.aliveScroll).setListNotSorted(list);
        }
        if (compound.func_150297_b("SetPos", 3)) {
            this.slot = compound.func_74762_e("SetPos");
        }
        if (compound.func_150297_b("SetDead", 1)) {
            this.isDead = compound.func_74767_n("SetDead");
            (this.isDead ? this.deadScroll : this.aliveScroll).setSelect(-1);
        }
        if ((sd = this.job.get(this.slot, this.isDead)) != null && sd.compound != null) {
            Client.sendData(EnumPacketServer.GetClone, true, this.slot, this.isDead);
        }
        this.func_73866_w_();
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        switch (textField.getID()) {
            case 0: {
                this.job.getOffset((boolean)false)[0] = textField.getInteger();
                break;
            }
            case 1: {
                this.job.getOffset((boolean)false)[1] = textField.getInteger();
                break;
            }
            case 2: {
                this.job.getOffset((boolean)false)[2] = textField.getInteger();
                break;
            }
            case 3: {
                this.job.getOffset((boolean)true)[0] = textField.getInteger();
                break;
            }
            case 4: {
                this.job.getOffset((boolean)true)[1] = textField.getInteger();
                break;
            }
            case 5: {
                this.job.getOffset((boolean)true)[2] = textField.getInteger();
                break;
            }
            case 6: {
                this.job.setCooldown(textField.getInteger());
                break;
            }
        }
    }
}

